 ; Ŀ
 ;   Ba - toggle the n in "* n *", "*`n'*", or "*n" in a text/attribute    
 ;   entity A/B or B/A.  Does the last character and some special cases.   
 ;   Copyright 2002, 2005 by Rocket Software Ltd.                          
 ;   Who is Gloria Monday and where is she going?                          
 ;                                                                         
 ;   Note: this is a bit strange.  It also toggles 1/2, F/R, and +/-.      
 ; 

 ; Ŀ
 ;   Flup - see if a string substitution can be made in a given entity,    
 ;   if so do it and update the entity and its parent entity (if any.)     
 ;   Arguments: Serch, the string to find.                                 
 ;              Repl, the new string.                                      
 ;              Exst, the existing string.                                 
 ;              Enam, the entity ename.                                    
 ;              Entt, the entity data listing.                             
 ;              Outer, the parent entity ename.                            
 ;   Calls Chug, returns T if a change was made, else nil.                 
 ; 
 (DEFUN FLUP (serch repl exst enam entt outer / gnuk)
  (setq gnuk (chug serch repl exst))
  (if (> (cadr gnuk) 0)
      (progn
           (setq gnuk (car gnuk))
           (entmod (subst (cons 1 gnuk) (assoc 1 entt) entt))
           (setq gnuk t)
           (entupd enam)
           (if (= (type outer) 'ENAME) (entupd outer)))
      (setq gnuk ()))
 gnuk)
 ; Ŀ
 ;   Flup end.                                                             
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   the (possibly modified) target string and the number of changes made. 
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug - end.                                                           
 ; 

 ; Ŀ
 ;   Ba.                                                                   
 ; 
 (DEFUN C:BA (/ snapp nent enam entt typ chra gnuk txt outer len)
  (defun *error* (shk /) (setvar "snapmode" snapp) (princ))
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq enam (car (setq nent (nentsel "\nBaa: "))))
  (setq typ (cdr (assoc 0 (setq entt (entget enam)))))
  (if (or (= "TEXT" typ) (= "MTEXT" typ) (= "ATTDEF" typ) (= "ATTRIB" typ))
      (progn
           (setq outer (car (reverse (car (reverse nent)))))
           (setq txt (cdr (assoc 1 entt)))
 ; Ŀ
 ;   Might want to fix this to accept variable length switch strings.      
 ; 
           (setq chra (substr txt (strlen txt)))
           (setq gnuk (cond ((= chra "A") "B")
                            ((= chra "B") "A")
                            ((= chra "C") "P")
                            ((= chra "P") "C")
                            ((= chra "+") "-")
                            ((= chra "-") "+")
                            ((= chra "F") "R")
                            ((= chra "R") "F")
                            ((= chra "H") "N")
                            ((= chra "N") "H")
                            ((= chra "1") "2")
                            ((= chra "2") "1")))
 ; Ŀ
 ;   If the last character was a known one then switch it.                 
 ; 
           (cond (gnuk
                  (if (> (setq len (strlen txt)) 1)
                         (setq gnuk (strcat (substr txt 1 (1- len)) gnuk)))
                  (entmod (subst (cons 1 gnuk) (assoc 1 entt) entt))
                  (entupd enam)
                  (if (= (type outer) 'ENAME) (entupd outer)))
 ; Ŀ
 ;   Special cases - if the last character wasn't changeable, check for    
 ;   known formats of A and B indicating a label.                          
 ; 
                 ((flup "`A'" "`B'" txt enam entt outer))
                 ((flup "`B'" "`A'" txt enam entt outer))
                 ((flup "'A'" "`B'" txt enam entt outer))
                 ((flup "'B'" "`A'" txt enam entt outer))
                 ((flup " B " " A " txt enam entt outer))
                 ((flup " A " " B " txt enam entt outer)))))
  (setvar "snapmode" snapp)
 (princ))